<?php
/*
Plugin Name: User Login Sessions with Popup
Description: Displays user login sessions in a popup with a responsive design.
Version: 1.4
Author: Your Name
*/

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Hook to log login events
function uls_log_user_login($user_login, $user)
{
    global $wpdb;

    $table_name = $wpdb->prefix . 'user_login_sessions';

    // Get IP address
    $user_ip = $_SERVER['REMOTE_ADDR'];

    // Insert login data
    $wpdb->insert(
        $table_name,
        array(
            'user_id' => $user->ID,
            'user_login' => $user_login,
            'user_ip' => $user_ip,
            'login_time' => current_time('mysql'),
        )
    );
}
add_action('wp_login', 'uls_log_user_login', 10, 2);

// Create database table on plugin activation
function uls_create_table()
{
    global $wpdb;
    $table_name = $wpdb->prefix . 'user_login_sessions';

    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        user_id bigint(20) NOT NULL,
        user_login varchar(60) NOT NULL,
        user_ip varchar(100) NOT NULL,
        login_time datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        PRIMARY KEY (id)
    ) $charset_collate;";

    require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
    dbDelta($sql);
}
register_activation_hook(__FILE__, 'uls_create_table');

// Shortcode to display button and popup
function uls_display_login_sessions_popup()
{
    if (is_user_logged_in()) {
        global $wpdb;
        $current_user = wp_get_current_user();
        $table_name = $wpdb->prefix . 'user_login_sessions';

        // Get the latest 5 login records
        $results = $wpdb->get_results(
            $wpdb->prepare(
                "SELECT user_ip, login_time FROM $table_name WHERE user_id = %d ORDER BY login_time DESC LIMIT 5",
                $current_user->ID
            )
        );

        // Add styles and scripts
        $output = '<style>
            .uls-popup-container {
                display: none;
                position: fixed;
                top: 50%;
                left: 50%;
                transform: translate(-50%, -50%);
                background: rgba(255, 255, 255, 0.95);
                border-radius: 12px;
                box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3);
                padding: 25px;
                width: 90%;
                max-width: 600px;
                z-index: 1000;
                animation: popupIn 0.4s ease-out;
            }
            @keyframes popupIn {
                0% { opacity: 0; transform: scale(0.9); }
                100% { opacity: 1; transform: scale(1); }
            }
            .uls-popup-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 15px;
                }
            .uls-popup-header h2 {
                margin: 0;
                font-size: 20px;
                color: #007BFF;
            }
            .uls-popup-close {
                cursor: pointer;
                font-size: 22px;
                color: #333;
            }
            .uls-popup-close:hover {
                color: #FF0000;
            }
            .uls-login-session {
                background: #f0f4f7;
                border: 1px solid #e1e8f0;
                border-radius: 8px;
                padding: 12px;
                margin-bottom: 12px;
                transition: transform 0.3s ease, background 0.3s ease;
            }
            .uls-login-session:hover {
                transform: scale(1.02);
                background: #e1e8f0;
            }
            .uls-login-session p {
                margin: 0;
                font-size: 16px;
                color: #333;
            }
            .uls-popup-button {
    background: linear-gradient(145deg, #007BFF, #00aaff);  /* خلفية تدريجية */
    color: #fff;  /* لون النص */
    border: none;
    padding: 15px 25px;  /* الحشو */
    border-radius: 8px;  /* الزوايا المدورة */
    cursor: pointer;  /* تغيير المؤشر عند التمرير فوق الزر */
    font-size: 18px;  /* حجم الخط */
    width: 100%;  /* جعل الزر يأخذ عرض العنصر الحاوي (الوالد) بالكامل */
    max-width: 100%;  /* تحديد الحد الأقصى للعرض (يمكن تغييره حسب الحاجة) */
    margin: auto;  /* لتوسيط الزر في الحاوية */
    box-sizing: border-box;  /* ضمان حساب الحشو والحدود داخل العرض */
    box-shadow: 0 4px 6px rgba(0, 123, 255, 0.2);  /* الظل */
    transition: background 0.3s ease, transform 0.3s ease;  /* تأثير التحول */
}

.uls-popup-button:focus {
    outline: none;  /* إزالة الإطار عند التركيز */
}

/* الشاشات الصغيرة (مثل الهواتف) */
@media (max-width: 767px) {
    .uls-popup-button {
        padding: 12px 20px;  /* تقليل الحشو للشاشات الصغيرة */
        font-size: 16px;  /* تقليل حجم الخط في الشاشات الصغيرة */
    }
}

/* الشاشات المتوسطة (مثل الأجهزة اللوحية) */
@media (max-width: 1024px) {
    .uls-popup-button {
        padding: 14px 22px;  /* تعديل الحشو حسب الحاجة */
        font-size: 17px;  /* ضبط حجم الخط للأجهزة اللوحية */
    }
}
            .uls-popup-button:hover {
                background: linear-gradient(145deg, #0066cc, #0099cc);
                transform: scale(1.05);
            }
            .uls-overlay {
                display: none;
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.5);
                z-index: 999;
            }
            @media screen and (max-width: 768px) {
                .uls-popup-container {
                    width: 95%;
                    max-width: 90%;
                    padding: 15px;
                }
                .uls-popup-button {
                    font-size: 16px;
                }
            }
        </style>';

        $output .= '<div class="uls-overlay" id="uls-overlay"></div>';
        $output .= '<div class="uls-popup-container" id="uls-popup">';
        $output .= '<div class="uls-popup-header">';
        $output .= '<h2></h2>';
        $output .= '<span class="uls-popup-close" id="uls-popup-close">&times;</span>';
        $output .= '</div>';

        if (!empty($results)) {
            foreach ($results as $row) {
                $output .= '<div class="uls-login-session">';
                $output .= '<p><strong>IP:</strong> ' . esc_html($row->user_ip) . '</p>';
                $output .= '<p><strong>Time:</strong> ' . esc_html($row->login_time) . '</p>';
                $output .= '</div>';
            }
        } else {
            $output .= '<p>No login sessions found.</p>';
        }

        $output .= '</div>';
        $output .= '<button class="uls-popup-button" id="uls-popup-button">عرض عمليات تسجيل الدخول</button>';

        $output .= '<script>
            document.getElementById("uls-popup-button").addEventListener("click", function() {
                document.getElementById("uls-popup").style.display = "block";
                document.getElementById("uls-overlay").style.display = "block";
            });

            document.getElementById("uls-popup-close").addEventListener("click", function() {
                document.getElementById("uls-popup").style.display = "none";
                document.getElementById("uls-overlay").style.display = "none";
            });

            document.getElementById("uls-overlay").addEventListener("click", function() {
                document.getElementById("uls-popup").style.display = "none";
                document.getElementById("uls-overlay").style.display = "none";
            });
        </script>';

        return $output;
    } else {
        return '<p>Please log in to view your login sessions.</p>';
    }
}
add_shortcode('user_login_sessions', 'uls_display_login_sessions_popup');